	  function [h, Err] = GDIFF_EQR_FIR(Norder, Be, D, W, Lorder)
 
	 %	Computes the impulse response of a linear-phase differentiator FIR filter using 
	 %	Parks-McClellan-Rabiners algorithm based on Remez algorithm.  
	 %
	 % Inputs:			
	 %  Norder 	is the filter order, i.e., Norder+1 taps.
	 %	Lorder	differentiator order, i.e., (jwT)^Lorder
	 %	Be		is a vector with length 2*Nband with the band edges starting 
	 %			with 0.0 and ending with  rad.
	 %	D		is a vector with length 2*Nband with the desired slope in the bands.
	 %	W 		is a vector with the weigths in the bands. 
	 
	 % Outputs:			
	 %    h 	is the impulse response of a linear-phase differentiator of order Norder.
	 %	 Err 	is the maximal error in the error function
	 %
	 %	Example of a differentiator
	 %   	Norder = 15; Be = [0 0.75*pi]; Dslope = [1]; W = [1];  Lorder = 3;
	 
	 % 	Toolbox for DIGITAL FILTERS USING MATLAB
	 
	 % 	Author: 		Lars Wanhammar 2014-11-15
	 % 	Modified by: 	
	 % 	Copyright:		by authors - not released for commercial use
	 % 	Version:		1 
	 % 	Known bugs: 
	 % 	Report bugs to:	Wanhammar@gmail.com
	 %
	 % References:	
	 %			[1] 	J.H. McClellan, T.W. Parks, L.R. Rabiner: FIR Linear Phase  
	 %					Design Program in "Programs for Digital Signal Processing,II"
	 %					IEEE Press, 1976.
	 %			[2] 	Selected Papers in Digital Signal Processing, II,IEEE Press, 1976.
	 %			|3]		C.A. Rahenkamp and B.V.K V. Kumar, Modifications to the McClellan,
	 %					Parks, and Rabiner Computer Program for Designing Higher Order 
	 %					Differentiating FIR Filters, IEEE Trans. Circuits and Systems, 
	 %					Vol. 6, pp. 1671-1674, Dec. 1986.
	 
	 % ==================  Input checks ===========================
	 % Lorder_odd Lorder_even  Nodd    Neven
	 %	  -			x			II    IV
	 %    x			-			I	  III
	 
	 Neg = mod(Lorder,2);	% if Neg = 1 Type I or III -  anisymmetric else II or IV
	  Ad = zeros(1,floor(Norder/2) + 2); Alpha = Ad; X = Ad; Y = Ad; H = Ad; Iext = Ad;
	 Lgrid = 32;	
	 Des = zeros(1, Lgrid*(Norder/2 +2)); 
	 Grid = Des; Wt = Des; Nbands = length(Be)/2;
	 Edge = zeros(1, 2*Nbands);  Fx = zeros(1, Nbands);  Deviat = Fx;	
	 
	 Ncoeff = Norder+1;			% Length of the FIR filter	
	 Nodd = mod(Ncoeff, 2);		% Nodd = 1 for odd number of taps, i.e., an			
	 Nfcns = floor(Ncoeff/2);	% even-order filter	
	 if (Nodd == 1) & (Neg == 0)
		 Nfcns = Nfcns+1; 			% Half the number of coefficients
	 end				
	 Edge(1:2*Nbands) = 0.5*Be/pi;	 
	 Fx = D(1:2:length(D));
	 % Ftype = 2;
	 % ===============================================
	 % Set up the dense grid.
	 Grid(1) = Edge(1); Delf = 0.5/(Lgrid*Nfcns);
	 % if (Ftype ~= 1) 
	 if (Edge(1) < Delf), Grid(1) = Delf; end
	 % end
	 j = 1; L = 1; Lband = 1;	goto = 1;
	 while goto < 5
		 switch goto 
		 case 1
			 Fup = Edge(L+1); goto = 2;
		 case 2
			 Temp = Grid(j);		
			 Des(j) = Fx(Lband)*Temp^Lorder;
			 Wt(j) = W(Lband); 
			 j = j+1; 
			 Grid(j) = Temp + Delf;
			 if (Grid(j) > Fup), goto = 3; else goto = 2; end
		 case 3
			 Grid(j-1) = Fup;	
			 Des(j-1) = Fx(Lband)*Fup^Lorder;
			 Wt(j-1) = W(Lband); 	
			 Lband = Lband+1; L = L+2;
			 if Lband > Nbands, goto = 10; end
			 if goto < 10, Grid(j) = Edge(L); goto = 1; end
		 end
	 end
	 %	k = length(Grid);
	 %	while Grid(k) == 0 |Grid(k) > 0.5
	 %		Grid(k) = [];
	 %		k=k-1;
	 %	end
	 %	k = length(Wate);
	 %	while Wt(k) == 0 
	 %		Wt(k) = [];
	 %		k=k-1;
	 %	end
	 Ngrid = j-1;
	 if (Neg == Nodd) & (Grid(Ngrid) > (0.5 - Delf)), Ngrid = Ngrid-1; end	
	 % Set up a new approximation problem which is equivalent to the orginal problem.
	 if Neg == 1 
		 a = (1+Nodd)*pi;
		 Change(1:Ngrid) = sin(a*Grid(1:Ngrid));	 
		 Des(1:Ngrid) = Des(1:Ngrid)./Change(1:Ngrid);
		 Wt(1:Ngrid) = Wt(1:Ngrid).*Change(1:Ngrid);
	 else
		 if Nodd == 0
			 Change(1:Ngrid) = cos(pi*Grid(1:Ngrid)); 
			 Des(1:Ngrid) = Des(1:Ngrid)./Change(1:Ngrid);
			 Wt(1:Ngrid) = Wt(1:Ngrid).*Change(1:Ngrid);
		 end
	 end 
	 Temp = floor((Ngrid-1)/Nfcns); 
	 for j = 1:Nfcns, Iext(j) = (j-1)*Temp+1; end 
	 Iext(Nfcns+1) = Ngrid;	 Nm1 = Nfcns-1;	 Nz = Nfcns+1;	
	 % ===============================================
	 % Call the REMEZ algorithm to do the approximation problem
	 
	 [h, Err, Dev] = REMEZ_EX(Ncoeff, Neg, Nfcns, Ngrid, Grid, Iext, Des, Wt);
	 Err = abs(Err)
 
	 % ===============================================
	 % Generate the complete impulse response
	 if Neg == 0
		 h = cat(2, h, fliplr(h(1:length(h)-Nodd))); 
	 else
		 h = cat(2, h, -fliplr(h(1:length(h)-Nodd)));
	 end
	 % 	disp(['Extremal Frequencies'])
	 %	Grid(Iext(1:Nz))'
	 if 1==2
		 figure(1)
		 wT = linspace(0,pi,1000);
		 H = freqz(h,1,wT);
		 PLOT_MAGNITUDE_Z_LS(wT, H, 0, pi, 'H_D_i_f_f')	
		 axis([0, pi, 0, 0.02 ]);	grid on
		 %		PLOT_MAGNITUDE_Z_LS(wT, H, 0, 0.022, 'H_D_i_f_f')			
		 h'
		 %		 figure(2)
		 %	 PLOT_IMPULSE_RESPONSE_Z(h)
	 end
	
